var replyta, titles, options;

$(document).ready(function() {
	chrome.storage.sync.get(function(objs) {
		titles = objs["custom titles"];
		options = objs;
		if (!options["spoilers"]) options["spoilers"] = "notfirst";
		if (!options["sticky topics"]) options["sticky topics"] = "optional";

		if (options["sticky topics"] != "never") {
			var numSticky = $("td img[src='/images/sticky.gif']").add("td img[src='/images/announce.gif']").length - 2;
			$("td img[src='/images/sticky.gif']")
				.add("td img[src='/images/announce.gif']")
				.filter(":eq(0)").closest("tr")
				.before("<tr><td class='lighttable' colspan='8' id='sticky_hider'>[-] Cкрыть прилепленные (" + numSticky + ")</td></tr>");
			$("#sticky_hider").css({"cursor": "pointer", "font-family": "monospace"}).click(function(){
				var str = $(this).text();
				if (str.indexOf("[-]") == 0)
					$(this).text("[+] Показать" + str.substring(10));
				else
					$(this).text("[-] Скрыть" + str.substring(12));
				$("td img[src='/images/sticky.gif']")
					.add("td img[src='/images/announce.gif']").closest("tr").toggle(400, "swing");
			});
			if (options["sticky topics"] == "always")
				$("#sticky_hider").click();
		}

		var utitle = $(".litleinfo").closest("td").find("div.comHeadcontent").find("span span:eq(0)");

		for (var name in titles) {
			$(utitle).filter(function() {
				return $(this).closest("div").find("a:eq(0)").text() == name
			}).text(titles[name]);
		}

		$(utitle).click(function(e){
			if (this.editing) return;
			if (!this.editable) this.editable = function() {
				var td = this;
				td.editing = true;
			
				var originalVal = $(td).html();					//save current value to restore if edit cancelled
				var inp = document.createElement("input");
				inp.type = "text";
				inp.value = originalVal;
				$(td).html("");
				td.appendChild(inp);
				inp.focus();
				$(inp).blur(function() {
					save();
				});
				$(inp).keydown(function(e) {
					if (e.keyCode == 27) { // ESC
						e.preventDefault;
						reset();
					} else if (e.keyCode == 13) { //Enter
						e.preventDefault;
						save();
					}
				});
				function save() {
					titles[$(inp).closest("div").find("a:eq(0)").text()] = $(inp).val();
					chrome.storage.sync.set({"custom titles": titles});

					$(td).html($(inp).val());
					td.editing = false;
				}
				function reset() {
					$(td).html(td.originalVal);
					td.editing = false;
				}
			};
			this.editable();
		});

		$("blockquote").find("noindex,font.small").css("cursor", "pointer");

		$("blockquote").find("noindex,font.small").parent().each(function(){
			$(this.childNodes).each(function(){
				if (this.nodeType === 3) {
					$(this).wrap("<span></span>");
				}
			});
		});

		if (options["spoilers"] == "all")
			$("blockquote").find("noindex,font.small").siblings().css("display", "none");
		else if (options["spoilers"] == "notfirst")
			$("blockquote").filter(function() {
				return $(this).parent().get(0).nodeName != "TD"
			}).find("noindex,font.small").siblings().css("display", "none");
		if (window.location.href.indexOf("#") != -1 && $("a[name='" + window.location.href.substring(window.location.href.indexOf("#")+1) + "']").length > 0)
			$('html, body').animate({
        			scrollTop: $("a[name='" + window.location.href.substring(window.location.href.indexOf("#")+1) + "']").offset().top
			});

		$("blockquote").find("noindex,font.small").on("click", function(){
			$(this).siblings().toggle();
		});
		$("font.post,blockquote").on("mouseup", function(e){
			e.stopPropagation();
			if (("" + window.getSelection()).length == 0) {
				$("#quote_selected").hide();
				return;
			}

			if (!$("#quote_selected").get(0)) {
				$("body").append("<div id=\"quote_selected\"><img src=\"/images/reply.gif\"/></div>");
				$("#quote_selected").click(function(){
					addQuote();
					$(this).hide();
				}).css({
					cursor: "pointer",
					position: "fixed",
					"background-color": "#E8DEC5",
					padding: "4px",
					border: "1pt solid",
					"border-radius": "4px"
				});

			}
			$("#quote_selected").css({top: e.clientY, left: e.clientX}).show();
			$("body").one("mouseup", function(){$("#quote_selected").hide();});
		});
	});
});

function addQuote() {
	var obj = window.getSelection();
	var user;
	if ($(obj.baseNode).closest("blockquote").find("font.small:eq(0)").length > 0) {
		user = $(obj.baseNode).closest("blockquote").find("font.small:eq(0)").text();
		user = user.substring(0, user.length-1);
	} else {
		user = $(obj.baseNode).closest("tr").prev().find("div.comHeadcontent").find("div.big a:eq(0)").text();
		user += " " + $.trim($(obj.baseNode).closest("tr").prev().find("td.subjecttable,td.newsubjecttable").find("font.small").contents()[0].nodeValue) + " пишет";
	}

	if (!replyta) {
		var w = window.open($(obj.baseNode).closest("tr").prev().find("td.subjecttable,td.newsubjecttable").find("a").filter(function(){
			return this.href.indexOf("newreply") != -1;
		})[0].href, "autoua_reply_window");
		w.onload = function(){			
			replyta = w.document.getElementById("compose-body");
			replyta.innerHTML += "[цитата=\"" + user + "\"]" + obj + "[/цитата]\n";
		};
		w.onunload = function() {
			replyta = null;
		}
	} else {
		replyta.innerHTML += "[цитата=\"" + user + "\"]" + obj + "[/цитата]\n";
		alert("Added quote to the reply form.");
	}
}
