var options;

$(document).ready(function() {
	chrome.storage.sync.get(null, function(obj) {
		options = obj;
		if (!options["spoilers"])
			options["spoilers"] = "notfirst";
		if (!options["sticky topics"])
			options["sticky topics"] = "optional";
		if (!options["custom titles"])
			options["custom titles"] = {};

		populateBody();

		$("input[type='radio'][name='spoilers']").prop("checked", "")
			.filter(function(){return $(this).val() == options["spoilers"];}).prop("checked", "true");
		$("input[type='radio'][name='spoilers']").change(function (e){
			options["spoilers"] = e.target.value;
		});

		$("input[type='radio'][name='sticky']").prop("checked", "")
			.filter(function(){return $(this).val() == options["sticky topics"];}).prop("checked", "true");
		$("input[type='radio'][name='sticky']").change(function (e){
			options["sticky topics"] = e.target.value;
		});

		$("#addbtn").click(function(){
			options["custom titles"][$("#user").val()] = $("#title").val();
			populateBody();
		});
		$("#save").click(function(){
			$("tbody input[type='text']").each(function(){
				options["custom titles"][$(this).closest("tr").find("td:eq(0)").text()] = $(this).val();
			});
			chrome.storage.sync.set(options, function(){alert("saved")});
		});
	});
});

function deleteTitle(btn) {
	delete options["custom titles"][$(btn).closest("tr").find("td:eq(0)").text()];
	populateBody();
}

function populateBody() {
	$("tbody").empty();
	for (var t in options["custom titles"]) {
		$("tbody").append(
			"<tr><td>" + t + "</td><td><span>"
			+ "<input type='text' value='" + options["custom titles"][t] + "'/>"
			+ "<button>remove</button>"
			+ "</span></td></tr>"
		);
	}
	$("tbody tr:even").toggleClass("even", true);
	$("tbody td button").click(function() {
		deleteTitle(this);
	});
}
